/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump.utilities;

import com.marklogic.contentpump.utilities.DocBuilder;
import com.marklogic.contentpump.utilities.XMLUtil;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.xerces.util.XML11Char;

public class XMLDocBuilder
extends DocBuilder {
    protected static String rootStart;
    protected static String rootEnd;
    static final String DEFAULT_ROOT_NAME = "root";

    @Override
    public void init(Configuration conf) {
        String rootName = conf.get("mapreduce.marklogic.delimited.rootname", DEFAULT_ROOT_NAME);
        rootStart = "<" + rootName + ">";
        rootEnd = "</" + rootName + ">";
    }

    @Override
    public void newDoc() throws IOException {
        this.sb = new StringBuilder();
        this.sb.append(rootStart);
    }

    @Override
    public void put(String key, String value) throws Exception {
        this.sb.append('<').append(key).append('>');
        this.sb.append(XMLUtil.convertToCDATA(value));
        this.sb.append("</").append(key).append('>');
    }

    @Override
    public void build() throws IOException {
        this.sb.append(rootEnd);
    }

    @Override
    public void configFields(Configuration conf, String[] fields) throws IOException {
        if (null != fields) {
            super.configFields(conf, fields);
            for (int i = 0; i < fields.length; ++i) {
                if (fields[i].trim().equals("") || XML11Char.isXML11ValidName((String)fields[i])) continue;
                fields[i] = XMLUtil.getValidName(fields[i]);
            }
        } else {
            throw new IOException("Fields not defined");
        }
    }
}

