/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.dom;

import com.marklogic.dom.AttrImpl;
import com.marklogic.dom.DocumentImpl;
import com.marklogic.tree.ExpandedTree;
import com.marklogic.tree.NodeKind;
import java.util.ArrayList;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;

public abstract class NodeImpl
implements Node {
    public static final Log LOG = LogFactory.getLog(NodeImpl.class);
    private static final NodeList emptyNodeList = new NodeList(){

        @Override
        public int getLength() {
            return 0;
        }

        @Override
        public Node item(int index) {
            return null;
        }
    };
    protected final ExpandedTree tree;
    protected final int node;

    NodeImpl(ExpandedTree tree, int node) {
        this.tree = tree;
        this.node = node;
    }

    public ExpandedTree getExpandedTree() {
        return this.tree;
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        throw new DOMException(7, null);
    }

    @Override
    public Node cloneNode(boolean deep) {
        throw new UnsupportedOperationException();
    }

    protected Node cloneNode(Document doc, boolean deep) {
        return null;
    }

    @Override
    public short compareDocumentPosition(Node other) throws DOMException {
        if (other instanceof NodeImpl) {
            NodeImpl otherNode = (NodeImpl)other;
            if (this.tree == otherNode.tree) {
                if (this.tree.nodeOrdinal[this.node] > this.tree.nodeOrdinal[otherNode.node]) {
                    int ancestor = this.tree.nodeParentNodeRepID[this.node];
                    while (ancestor != Integer.MAX_VALUE && this.tree.nodeOrdinal[ancestor] >= this.tree.nodeOrdinal[otherNode.node]) {
                        if (ancestor == otherNode.node) {
                            return 10;
                        }
                        ancestor = this.tree.nodeParentNodeRepID[ancestor];
                    }
                    return 2;
                }
                int ancestor = this.tree.nodeParentNodeRepID[otherNode.node];
                while (ancestor != Integer.MAX_VALUE && this.tree.nodeOrdinal[ancestor] <= this.tree.nodeOrdinal[otherNode.node]) {
                    if (ancestor == this.node) {
                        return 20;
                    }
                    ancestor = this.tree.nodeParentNodeRepID[ancestor];
                }
                return 4;
            }
            return 1;
        }
        throw new DOMException(9, null);
    }

    @Override
    public NamedNodeMap getAttributes() {
        return null;
    }

    @Override
    public String getBaseURI() {
        return this.tree.getDocumentURI();
    }

    @Override
    public NodeList getChildNodes() {
        return emptyNodeList;
    }

    @Override
    public Object getFeature(String feature, String version) {
        assert (false);
        return this;
    }

    @Override
    public Node getFirstChild() {
        return null;
    }

    @Override
    public Node getLastChild() {
        return null;
    }

    @Override
    public String getLocalName() {
        return null;
    }

    @Override
    public String getNamespaceURI() {
        return null;
    }

    protected Node getNextChild(int node) {
        return null;
    }

    @Override
    public Node getNextSibling() {
        NodeImpl p = (NodeImpl)this.getParentNode();
        return p == null ? null : p.getNextChild(this.node);
    }

    @Override
    public abstract String getNodeName();

    @Override
    public short getNodeType() {
        return NodeKind.domType(this.tree.nodeKind[this.node]);
    }

    @Override
    public String getNodeValue() throws DOMException {
        return null;
    }

    @Override
    public Document getOwnerDocument() {
        return (DocumentImpl)this.tree.node(0);
    }

    @Override
    public Node getParentNode() {
        return this.tree.node(this.tree.nodeParentNodeRepID[this.node]);
    }

    protected int getPrefixID(int uriAtom) {
        return -1;
    }

    @Override
    public String getPrefix() {
        return null;
    }

    protected Node getPreviousChild(int child) {
        return null;
    }

    @Override
    public Node getPreviousSibling() {
        NodeImpl p = (NodeImpl)this.getParentNode();
        return p == null ? null : p.getPreviousChild(this.node);
    }

    private boolean hasTextContent(Node child) {
        return child.getNodeType() != 8 && child.getNodeType() != 7;
    }

    @Override
    public String getTextContent() throws DOMException {
        StringBuilder sb = new StringBuilder();
        this.getTextContent(sb);
        return sb.toString();
    }

    private void getTextContent(StringBuilder sb) throws DOMException {
        NodeList children = this.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!this.hasTextContent(child)) continue;
            sb.append(child.getTextContent());
        }
    }

    @Override
    public Object getUserData(String key) {
        throw new DOMException(9, null);
    }

    @Override
    public boolean hasAttributes() {
        return false;
    }

    @Override
    public boolean hasChildNodes() {
        return false;
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        throw new DOMException(7, null);
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        short type = this.getNodeType();
        if (type == 1 && !(this instanceof AttrImpl)) {
            throw new UnsupportedOperationException();
        }
        Node p = this.getParentNode();
        return p.isDefaultNamespace(namespaceURI);
    }

    private boolean notequals(String a, String b) {
        if (a == null) {
            return b != null;
        }
        return !a.equals(b);
    }

    @Override
    public boolean isEqualNode(Node other) {
        int i;
        if (other == null) {
            return false;
        }
        if (this.getNodeType() != other.getNodeType()) {
            return false;
        }
        if (!this.getLocalName().equals(other.getLocalName())) {
            return false;
        }
        if (this.notequals(this.getNamespaceURI(), other.getNamespaceURI())) {
            return false;
        }
        if (this.notequals(this.getPrefix(), other.getPrefix())) {
            return false;
        }
        if (this.notequals(this.getNodeValue(), other.getNodeValue())) {
            return false;
        }
        if (this.hasChildNodes() != other.hasChildNodes()) {
            return false;
        }
        if (this.hasAttributes() != other.hasAttributes()) {
            return false;
        }
        if (this.hasChildNodes()) {
            NamedNodeMap thisAttr = this.getAttributes();
            NamedNodeMap otherAttr = other.getAttributes();
            if (thisAttr.getLength() != otherAttr.getLength()) {
                return false;
            }
            for (i = 0; i < thisAttr.getLength(); ++i) {
                if (!thisAttr.item(i).isEqualNode(otherAttr.item(i))) continue;
                return false;
            }
        }
        if (this.hasAttributes()) {
            NodeList thisChild = this.getChildNodes();
            NodeList otherChild = other.getChildNodes();
            if (thisChild.getLength() != otherChild.getLength()) {
                return false;
            }
            for (i = 0; i < thisChild.getLength(); ++i) {
                if (!thisChild.item(i).isEqualNode(otherChild.item(i))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isSameNode(Node other) {
        return other instanceof NodeImpl && ((NodeImpl)other).tree == this.tree && ((NodeImpl)other).node == this.node;
    }

    @Override
    public boolean isSupported(String feature, String version) {
        return "Core".equalsIgnoreCase(feature) || "XML".equalsIgnoreCase(feature);
    }

    protected int getNSNodeID(long ordinal, long minOrdinal) {
        if (ordinal < minOrdinal) {
            return -1;
        }
        int idx = this.getNSNodeID(ordinal);
        if (idx >= 0 && this.tree.nsNodeOrdinal[idx] >= minOrdinal) {
            return idx;
        }
        return -1;
    }

    protected int getNSNodeID(long ordinal) {
        int R = this.tree.numNSNodeReps;
        if (R == 0) {
            return -1;
        }
        int L = 0;
        while (L + 1 < R) {
            int M = L + R >>> 1;
            if (ordinal < this.tree.nsNodeOrdinal[M]) {
                R = M;
                continue;
            }
            L = M;
        }
        if (ordinal < this.tree.nsNodeOrdinal[L]) {
            --L;
        }
        while (L != -1 && this.tree.nsNodePrefixAtom[L] == -1) {
            L = this.tree.nsNodePrevNSNodeRepID[L];
        }
        return L;
    }

    protected int nextNSNodeID(int ns, long minOrdinal) {
        do {
            if ((ns = this.tree.nsNodePrevNSNodeRepID[ns]) != -1) continue;
            return -1;
        } while (this.tree.nsNodePrefixAtom[ns] == -1);
        if (this.tree.nsNodeOrdinal[ns] < minOrdinal) {
            ns = -1;
        }
        return ns;
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        return null;
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        return null;
    }

    @Override
    public void normalize() {
        throw new DOMException(7, null);
    }

    @Override
    public Node removeChild(Node oldChild) throws DOMException {
        throw new DOMException(7, null);
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        throw new DOMException(7, null);
    }

    @Override
    public void setNodeValue(String nodeValue) throws DOMException {
        throw new DOMException(7, null);
    }

    @Override
    public void setPrefix(String prefix) throws DOMException {
        throw new DOMException(7, null);
    }

    @Override
    public void setTextContent(String textContent) throws DOMException {
        throw new DOMException(7, null);
    }

    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        throw new DOMException(9, null);
    }

    protected NodeList getElementsByTagNameNSOrNodeName(String namespaceURI, String name, final boolean nodeName) {
        final String tagname = name;
        final String ns = namespaceURI;
        final NodeImpl thisNode = this;
        return new NodeList(){
            protected ArrayList<Node> elementList = new ArrayList();
            protected boolean done = false;

            protected void init() {
                if (this.done) {
                    return;
                }
                Stack<Node> childrenStack = new Stack<Node>();
                childrenStack.push(thisNode);
                boolean root = true;
                while (!childrenStack.isEmpty()) {
                    Node curr = (Node)childrenStack.pop();
                    NodeList children = curr.getChildNodes();
                    for (int childi = children.getLength() - 1; childi >= 0; --childi) {
                        if (children.item(childi).getNodeType() != 1) continue;
                        childrenStack.push(children.item(childi));
                    }
                    if (root) {
                        root = false;
                        continue;
                    }
                    if (nodeName) {
                        if (!curr.getNodeName().equals(tagname) && !tagname.equals("*")) continue;
                        this.elementList.add(curr);
                        continue;
                    }
                    if ("*".equals(ns) && "*".equals(tagname)) {
                        this.elementList.add(curr);
                        continue;
                    }
                    if (ns != null) {
                        if (!ns.equals("*") && !ns.equals(curr.getNamespaceURI()) || !tagname.equals("*") && !tagname.equals(curr.getLocalName())) continue;
                        this.elementList.add(curr);
                        continue;
                    }
                    if (!tagname.equals("*") && !tagname.equals(curr.getLocalName())) continue;
                    this.elementList.add(curr);
                }
                this.done = true;
            }

            @Override
            public int getLength() {
                this.init();
                return this.elementList.size();
            }

            @Override
            public Node item(int index) {
                this.init();
                return index < this.getLength() ? this.elementList.get(index) : null;
            }
        };
    }

    protected String builtinNSPrefix(String URI2) {
        if (URI2 == null) {
            return null;
        }
        if (URI2.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        if (URI2.equals("http://www.w3.org/2000/xmlns/")) {
            return "xmlns";
        }
        if (URI2.equals("http://www.w3.org/2001/XMLSchema")) {
            return "xs";
        }
        if (URI2.equals("http://www.w3.org/2001/XMLSchema-instance")) {
            return "xsi";
        }
        if (URI2.equals("http://www.w3.org/2003/05/xpath-datatypes")) {
            return "xdt";
        }
        if (URI2.equals("http://marklogic.com/xdmp")) {
            return "xdmp";
        }
        if (URI2.equals("http://marklogic.com/xqe")) {
            return "xqe";
        }
        if (URI2.equals("http://marklogic.com/xdmp/security")) {
            return "sec";
        }
        if (URI2.equals("http://www.w3.org/2005/xqt-errors")) {
            return "err";
        }
        if (URI2.equals("http://marklogic.com/xdmp/error")) {
            return "error";
        }
        if (URI2.equals("http://marklogic.com/xdmp/directory")) {
            return "dir";
        }
        if (URI2.equals("DAV:")) {
            return "dav";
        }
        if (URI2.equals("http://marklogic.com/xdmp/lock")) {
            return "lock";
        }
        if (URI2.equals("http://marklogic.com/xdmp/property")) {
            return "prop";
        }
        return null;
    }
}

