/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.io;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class BiendianDataInputStream
extends InputStream
implements DataInput {
    private final InputStream in;
    private final DataInputStream di;
    private final byte[] buf = new byte[8];
    private boolean littleEndian = true;

    public BiendianDataInputStream(InputStream in) {
        this.in = in;
        this.di = new DataInputStream(in);
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public final void setLittleEndian(boolean littleEndian) {
        this.littleEndian = littleEndian;
    }

    public final boolean isLittleEndian() {
        return this.littleEndian;
    }

    @Override
    public final int read(byte[] b) throws IOException {
        return this.di.read(b, 0, b.length);
    }

    @Override
    public final int read(byte[] b, int off, int len) throws IOException {
        return this.di.read(b, off, len);
    }

    @Override
    public final void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public final void readFully(byte[] b, int off, int len) throws IOException {
        this.di.readFully(b, off, len);
    }

    @Override
    public final int skipBytes(int n) throws IOException {
        return this.di.skipBytes(n);
    }

    public final long skipBytes(long n) throws IOException {
        long total = 0L;
        while (n > Integer.MAX_VALUE) {
            int skipped = this.di.skipBytes(Integer.MAX_VALUE);
            n -= (long)skipped;
            total += (long)skipped;
        }
        return total + (long)this.di.skipBytes((int)n);
    }

    @Override
    public final boolean readBoolean() throws IOException {
        return this.di.readBoolean();
    }

    @Override
    public final byte readByte() throws IOException {
        return this.di.readByte();
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        return this.di.readUnsignedByte();
    }

    @Override
    public final short readShort() throws IOException {
        if (this.littleEndian) {
            int b;
            int a = this.in.read();
            if ((a | (b = this.in.read())) < 0) {
                throw new EOFException();
            }
            return (short)((b << 8) + (a << 0));
        }
        return this.di.readShort();
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        if (this.littleEndian) {
            int b;
            int a = this.in.read();
            if ((a | (b = this.in.read())) < 0) {
                throw new EOFException();
            }
            return (b << 8) + (a << 0);
        }
        return this.di.readUnsignedShort();
    }

    @Override
    public final char readChar() throws IOException {
        if (this.littleEndian) {
            int b;
            int a = this.in.read();
            if ((a | (b = this.in.read())) < 0) {
                throw new EOFException();
            }
            return (char)((b << 8) + (a << 0));
        }
        return this.di.readChar();
    }

    @Override
    public final int readInt() throws IOException {
        this.di.readFully(this.buf, 0, 4);
        if (this.littleEndian) {
            return ((this.buf[3] & 0xFF) << 24) + ((this.buf[2] & 0xFF) << 16) + ((this.buf[1] & 0xFF) << 8) + ((this.buf[0] & 0xFF) << 0);
        }
        return ((this.buf[0] & 0xFF) << 24) + ((this.buf[1] & 0xFF) << 16) + ((this.buf[2] & 0xFF) << 8) + ((this.buf[3] & 0xFF) << 0);
    }

    @Override
    public final long readLong() throws IOException {
        if (this.littleEndian) {
            this.di.readFully(this.buf, 0, 8);
            return ((long)this.buf[7] << 56) + ((long)(this.buf[6] & 0xFF) << 48) + ((long)(this.buf[5] & 0xFF) << 40) + ((long)(this.buf[4] & 0xFF) << 32) + ((long)(this.buf[3] & 0xFF) << 24) + (long)((this.buf[2] & 0xFF) << 16) + (long)((this.buf[1] & 0xFF) << 8) + (long)((this.buf[0] & 0xFF) << 0);
        }
        return this.di.readLong();
    }

    @Override
    public final float readFloat() throws IOException {
        return this.di.readFloat();
    }

    @Override
    public final double readDouble() throws IOException {
        return this.di.readDouble();
    }

    @Override
    public final String readLine() throws IOException {
        return this.di.readLine();
    }

    @Override
    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public static final String readUTF(DataInput in) throws IOException {
        return DataInputStream.readUTF(in);
    }

    @Override
    public int read() throws IOException {
        return this.di.read();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

