/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.io;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Decoder {
    public static final Log LOG = LogFactory.getLog(Decoder.class);
    DataInput in;
    int numBitsInReg = 0;
    public long reg = 0L;
    static final byte[] unary1 = Decoder.unary1Make();
    static final byte[] unary2 = Decoder.unary2Make();
    static final byte[] unsigned1 = Decoder.unsigned1Make();
    static final short[] unsigned2 = Decoder.unsigned2Make();
    static final int[] unsigned3 = Decoder.unsigned3Make();

    public Decoder(DataInput in) {
        this.in = in;
    }

    private void load() throws IOException {
        try {
            long bits = (long)this.in.readInt() & 0xFFFFFFFFL;
            this.reg |= bits << this.numBitsInReg;
            this.numBitsInReg += 32;
        }
        catch (EOFException e) {
            return;
        }
    }

    private boolean load32(int[] array, int index) {
        try {
            array[index] = this.in.readInt();
            return true;
        }
        catch (EOFException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    public long decodeUnsignedLong() throws IOException {
        long lobits = (long)this.decodeUnsigned() & 0xFFFFFFFFL;
        long hibits = (long)this.decodeUnsigned() & 0xFFFFFFFFL;
        return hibits << 32 | lobits;
    }

    public long decode64bits() throws IOException {
        long lobits = (long)this.decode32bits() & 0xFFFFFFFFL;
        long hibits = (long)this.decode32bits() & 0xFFFFFFFFL;
        return hibits << 32 | lobits;
    }

    public int decode32bits() throws IOException {
        if (this.numBitsInReg == 0) {
            return this.in.readInt();
        }
        if (32 > this.numBitsInReg) {
            this.load();
        }
        int val = (int)(this.reg & 0xFFFFFFFFL);
        this.reg >>>= 32;
        this.numBitsInReg -= 32;
        return val;
    }

    public double decodeDouble() throws IOException {
        long lobits = (long)this.decode32bits() & 0xFFFFFFFFL;
        long hibits = (long)this.decode32bits() & 0xFFFFFFFFL;
        long bits = hibits << 32 | lobits;
        return Double.longBitsToDouble(bits);
    }

    public void realign() {
        if (this.numBitsInReg < 32) {
            this.reg = 0L;
            this.numBitsInReg = 0;
        } else {
            this.reg >>= this.numBitsInReg - 32;
            this.numBitsInReg = 32;
        }
    }

    public void decode(int[] array, int count) throws IOException {
        if (count <= 4) {
            for (int i = 0; i < count; ++i) {
                array[i] = this.decode32bits();
            }
        } else {
            int i = 0;
            this.realign();
            if (this.numBitsInReg == 32) {
                ++i;
                array[0] = (int)this.reg;
                this.reg = 0L;
                this.numBitsInReg = 0;
            }
            while (i < count && this.load32(array, i)) {
                ++i;
            }
        }
    }

    public int decodeUnary() throws IOException {
        int v;
        int e;
        int n;
        if (this.numBitsInReg < 16) {
            this.load();
        }
        if ((n = (e = unary1[(int)this.reg & 0xFF] & 0xFF) + 1) <= 8) {
            v = e;
        } else {
            e = unary2[(int)this.reg & 0xFFFF] & 0xFF;
            n = e + 1;
            if (n <= 16) {
                v = e;
            } else {
                return this._decodeUnary();
            }
        }
        this.reg >>>= n;
        this.numBitsInReg -= n;
        return v;
    }

    int _decodeUnary() throws IOException {
        int i = 1;
        while (true) {
            long msk;
            if (i > this.numBitsInReg) {
                this.load();
            }
            if ((this.reg & (msk = (1L << i) - 1L)) == msk >>> 1) {
                this.reg >>>= i;
                this.numBitsInReg -= i;
                return i - 1;
            }
            ++i;
        }
    }

    public int decodeUnsigned() throws IOException {
        int v;
        int e;
        int n;
        if (this.numBitsInReg < 16) {
            this.load();
        }
        if ((n = (e = unsigned1[(int)(this.reg & 0x3FL)]) >>> 5) <= 6) {
            v = e & 0x1F;
        } else {
            e = unsigned2[(int)(this.reg & 0x7FFL)];
            n = e >>> 12;
            if (n <= 11) {
                v = e & 0xFFF;
            } else {
                e = unsigned3[(int)(this.reg & 0xFFFFL)];
                n = e >>> 16;
                if (n <= 16) {
                    v = e & 0xFFFF;
                } else {
                    return this._decodeUnsigned();
                }
            }
        }
        this.reg >>>= n;
        this.numBitsInReg -= n;
        return v;
    }

    int _decodeUnsigned() throws IOException {
        int nbits = this.decodeUnary() * 4;
        if (nbits > this.numBitsInReg) {
            this.load();
        }
        long val = this.reg & (nbits < 64 ? (1L << nbits) - 1L : -1L);
        for (int i = 0; i < nbits; i += 4) {
            val += 1L << i;
        }
        this.reg >>>= nbits;
        this.numBitsInReg -= nbits;
        return (int)(val & 0xFFFFFFFFL);
    }

    public int decodeUnsigned(int n) throws IOException {
        if (n > this.numBitsInReg) {
            this.load();
        }
        long v = this.reg & (n < 64 ? (1L << n) - 1L : -1L);
        this.reg >>>= n;
        this.numBitsInReg -= n;
        return (int)(v & 0xFFFFFFFFL);
    }

    private static final byte[] unary1Make() {
        int i;
        byte[] table = new byte[256];
        block0: for (i = 0; i < 256; ++i) {
            table[i] = -1;
            for (int j = 0; j < 8; ++j) {
                if ((i & (1 << j + 1) - 1) != (1 << j) - 1) continue;
                table[i] = (byte)j;
                continue block0;
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"unary1 ");
            for (i = 0; i < 256; ++i) {
                LOG.trace((Object)String.format("%02x \n", table[i]));
            }
        }
        return table;
    }

    private static final byte[] unary2Make() {
        byte[] table = new byte[65536];
        block0: for (int i = 0; i < 65536; ++i) {
            table[i] = -1;
            for (int j = 0; j < 16; ++j) {
                if ((i & (1 << j + 1) - 1) != (1 << j) - 1) continue;
                table[i] = (byte)j;
                continue block0;
            }
        }
        return table;
    }

    private static final byte[] unsigned1Make() {
        int i;
        byte[] table = new byte[64];
        for (i = 0; i < 64; ++i) {
            byte entry = unary1[i];
            int bbits = entry * 4;
            int ubits = entry + 1;
            if (bbits + ubits > 6) {
                table[i] = -32;
                continue;
            }
            int val = i >>> ubits & (1 << bbits) - 1;
            for (int j = 0; j < bbits; j += 4) {
                val += 1 << j;
            }
            table[i] = (byte)(bbits + ubits << 5 | val);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"unsigned1 ");
            for (i = 0; i < 64; ++i) {
                LOG.trace((Object)String.format("%02x \n", table[i]));
            }
        }
        return table;
    }

    private static final short[] unsigned2Make() {
        int i;
        short[] table = new short[2048];
        for (i = 0; i < 2048; ++i) {
            byte entry = unary2[i];
            int bbits = entry * 4;
            int ubits = entry + 1;
            if (bbits + ubits > 11) {
                table[i] = -4096;
                continue;
            }
            int val = i >>> ubits & (1 << bbits) - 1;
            for (int j = 0; j < bbits; j += 4) {
                val += 1 << j;
            }
            table[i] = (short)(bbits + ubits << 12 | val);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"unsigned2 ");
            for (i = 0; i < 64; ++i) {
                LOG.trace((Object)String.format("%04x \n", table[i]));
            }
        }
        return table;
    }

    private static final int[] unsigned3Make() {
        int i;
        int[] table = new int[65536];
        for (i = 0; i < 65536; ++i) {
            int entry = unary2[i] & 0xFF;
            int bbits = entry * 4;
            int ubits = entry + 1;
            if (bbits + ubits > 16) {
                table[i] = -65536;
                continue;
            }
            int val = i >>> ubits & (1 << bbits) - 1;
            for (int j = 0; j < bbits; j += 4) {
                val += 1 << j;
            }
            table[i] = bbits + ubits << 16 | val;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"unsigned3 ");
            for (i = 0; i < 64; ++i) {
                LOG.trace((Object)String.format("%08x \n", table[i]));
            }
        }
        return table;
    }
}

