/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce;

import com.marklogic.mapreduce.utilities.InternalUtilities;
import com.marklogic.mapreduce.utilities.LegacyAssignmentPolicy;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;

public class DocumentURI
implements WritableComparable<DocumentURI>,
Cloneable {
    protected String uri;

    public DocumentURI() {
    }

    public DocumentURI(String uri) {
        this.uri = uri;
    }

    public DocumentURI(DocumentURI uri) {
        this.uri = uri.uri;
    }

    public void readFields(DataInput in) throws IOException {
        this.uri = Text.readString((DataInput)in);
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.uri);
    }

    public String getUri() {
        return this.uri;
    }

    @Deprecated
    public String getUnparsedUri() {
        return InternalUtilities.unparse(this.uri);
    }

    public void setUri(String uri) {
        this.uri = uri == null ? "" : uri;
    }

    public int compareTo(DocumentURI o) {
        return this.uri.compareTo(o.getUri());
    }

    public String toString() {
        return this.uri;
    }

    @Deprecated
    public int getPlacementId(int size) {
        switch (size) {
            case 0: {
                throw new IllegalArgumentException("getPlacementId(size = 0)");
            }
            case 1: {
                return 0;
            }
        }
        return LegacyAssignmentPolicy.getPlacementId(this, size);
    }

    public Object clone() {
        return new DocumentURI(this.uri);
    }

    public void validate() {
        if (this.uri.isEmpty() || Character.isWhitespace(this.uri.charAt(0)) || Character.isWhitespace(this.uri.charAt(this.uri.length() - 1))) {
            throw new IllegalStateException("Invalid URI Format: " + this.uri);
        }
        for (int i = 0; i < this.uri.length(); ++i) {
            if (this.uri.charAt(i) >= ' ') continue;
            throw new IllegalStateException("Invalid URI Format: " + this.uri);
        }
    }

    public boolean equals(Object uri) {
        if (uri instanceof DocumentURI) {
            return this.uri.equals(((DocumentURI)uri).getUri());
        }
        return false;
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public static void main(String[] args) throws URISyntaxException {
        HashMap<String, DocumentURI> map = new HashMap<String, DocumentURI>();
        for (String arg : args) {
            URI uri = new URI(null, null, null, 0, arg, null, null);
            System.out.println("URI encoded: " + uri.toString());
            URI outuri = new URI(uri.toString());
            System.out.println("URI decoded: " + outuri.getPath());
            map.put(arg, new DocumentURI(arg));
        }
    }
}

