/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce;

import com.marklogic.mapreduce.MarkLogicRecordReader;
import com.marklogic.mapreduce.utilities.InternalUtilities;
import com.marklogic.xcc.ResultItem;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.util.ReflectionUtils;

public class KeyValueReader<KEYIN, VALUEIN>
extends MarkLogicRecordReader<KEYIN, VALUEIN> {
    public static final Log LOG = LogFactory.getLog(KeyValueReader.class);
    static final float VALUE_TO_FRAGMENT_RATIO = 100.0f;
    private KEYIN key;
    private VALUEIN value;
    private Class<? extends WritableComparable> keyClass;
    private Class<? extends Writable> valueClass;

    public KeyValueReader(Configuration conf) {
        super(conf);
        this.keyClass = conf.getClass("mapreduce.marklogic.input.keyclass", Text.class, WritableComparable.class);
        this.valueClass = conf.getClass("mapreduce.marklogic.input.valueclass", Text.class, Writable.class);
    }

    public VALUEIN getCurrentValue() throws IOException, InterruptedException {
        return this.value;
    }

    public KEYIN getCurrentKey() throws IOException, InterruptedException {
        return this.key;
    }

    @Override
    protected void endOfResult() {
        this.key = null;
        this.value = null;
    }

    @Override
    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (this.result != null && this.result.hasNext()) {
            if (this.key == null) {
                this.key = ReflectionUtils.newInstance(this.keyClass, (Configuration)this.getConf());
            }
            ResultItem item = this.result.next();
            InternalUtilities.assignResultValue(this.keyClass, item, this.key);
            if (this.result.hasNext()) {
                if (this.value == null) {
                    this.value = ReflectionUtils.newInstance(this.valueClass, (Configuration)this.getConf());
                }
                item = this.result.next();
                InternalUtilities.assignResultValue(this.valueClass, item, this.value);
                ++this.count;
                return true;
            }
        }
        this.endOfResult();
        return false;
    }

    @Override
    protected boolean nextResult(ResultItem result) {
        return false;
    }

    @Override
    protected float getDefaultRatio() {
        return 100.0f;
    }
}

