/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce;

import com.marklogic.mapreduce.BinaryDocument;
import com.marklogic.mapreduce.ContentType;
import com.marklogic.mapreduce.MarkLogicNode;
import com.marklogic.tree.ExpandedTree;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;

public class LargeBinaryDocument
extends BinaryDocument {
    public static final Log LOG = LogFactory.getLog(LargeBinaryDocument.class);
    protected Path path;
    protected long offset;
    protected long size;
    protected long binaryOrigLen;
    protected Configuration conf;

    public LargeBinaryDocument() {
    }

    public LargeBinaryDocument(Configuration conf, Path forestDir, ExpandedTree tree) {
        this.path = new Path(forestDir, tree.getPathToBinary());
        this.offset = tree.binaryOffset;
        this.size = tree.binarySize;
        this.binaryOrigLen = tree.binaryOrigLen;
        this.conf = conf;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Large binary path: " + this.path));
            LOG.trace((Object)("offset: " + this.offset));
            LOG.trace((Object)("size: " + this.size));
            LOG.trace((Object)("origLen: " + this.binaryOrigLen));
        }
    }

    public Path getPath() {
        return this.path;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getBinaryOrigLen() {
        return this.binaryOrigLen;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.path = new Path(Text.readString((DataInput)in));
        this.offset = in.readLong();
        this.size = in.readLong();
        this.binaryOrigLen = in.readLong();
        this.conf = new Configuration();
        this.conf.readFields(in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        Text.writeString((DataOutput)out, (String)this.path.toString());
        out.writeLong(this.offset);
        out.writeLong(this.size);
        out.writeLong(this.binaryOrigLen);
        this.conf.write(out);
    }

    @Override
    public byte[] getContentAsByteArray() {
        if (this.size > Integer.MAX_VALUE) {
            throw new ArrayIndexOutOfBoundsException("Array size = " + this.size);
        }
        return this.getContentAsByteArray(0, (int)this.size);
    }

    public byte[] getContentAsByteArray(int offset, int len) {
        FSDataInputStream is = null;
        try {
            FileSystem fs = this.path.getFileSystem(this.conf);
            if (!fs.exists(this.path)) {
                throw new RuntimeException("File not found: " + this.path);
            }
            FileStatus status = fs.getFileStatus(this.path);
            if (status.getLen() < (long)offset) {
                throw new RuntimeException("Reached end of file: " + this.path);
            }
            byte[] buf = new byte[len];
            is = fs.open(this.path);
            int skipped = 0;
            for (int toSkip = offset; toSkip < offset; toSkip -= skipped) {
                skipped = is.skipBytes(offset);
            }
            for (int bytesRead = 0; bytesRead < len; bytesRead += is.read(buf, bytesRead, len - bytesRead)) {
            }
            byte[] byArray = buf;
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException("Error accessing file: " + this.path, e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public MarkLogicNode getContentAsMarkLogicNode() {
        throw new UnsupportedOperationException("Cannot convert binary data to MarkLogicNode.");
    }

    @Override
    public Text getContentAsText() {
        throw new UnsupportedOperationException("Cannot convert binary data to Text.");
    }

    @Override
    public ContentType getContentType() {
        return ContentType.BINARY;
    }

    @Override
    public String getContentAsString() throws UnsupportedEncodingException {
        throw new UnsupportedOperationException("Cannot convert binary data to String.");
    }

    @Override
    public InputStream getContentAsByteStream() {
        FSDataInputStream is = null;
        try {
            FileSystem fs = this.path.getFileSystem(this.conf);
            if (!fs.exists(this.path)) {
                throw new RuntimeException("File not found: " + this.path);
            }
            is = fs.open(this.path);
            return is;
        }
        catch (IOException e) {
            throw new RuntimeException("Error accessing file: " + this.path, e);
        }
    }

    @Override
    public long getContentSize() {
        return this.size;
    }

    @Override
    public boolean isStreamable() {
        return true;
    }
}

