/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce;

import com.marklogic.mapreduce.utilities.ForestHost;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;

public class MarkLogicInputSplit
extends InputSplit
implements Writable {
    private long start = 0L;
    private long length = 0L;
    private BigInteger forestId;
    private String[] hostName;
    private boolean isLastSplit;
    private List<ForestHost> replicas;

    public MarkLogicInputSplit() {
    }

    public MarkLogicInputSplit(long start, long length, BigInteger forestId, String hostName, List<ForestHost> replicas) {
        this.start = start;
        this.length = length;
        this.forestId = forestId;
        this.hostName = new String[1];
        this.hostName[0] = hostName;
        this.replicas = replicas;
    }

    public long getLength() throws IOException, InterruptedException {
        return this.length;
    }

    public boolean isLastSplit() {
        return this.isLastSplit;
    }

    public String[] getLocations() throws IOException, InterruptedException {
        return this.hostName;
    }

    public long getStart() {
        return this.start;
    }

    public void setStart(long start) {
        this.start = start;
    }

    public BigInteger getForestId() {
        return this.forestId;
    }

    public void setForestId(BigInteger forestId) {
        this.forestId = forestId;
    }

    public void setHostName(String[] hostName) {
        this.hostName = hostName;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public void setLastSplit(boolean isLast) {
        this.isLastSplit = isLast;
    }

    public List<ForestHost> getReplicas() {
        return this.replicas;
    }

    public void readFields(DataInput in) throws IOException {
        this.start = in.readLong();
        this.length = in.readLong();
        Text forestIdText = new Text();
        forestIdText.readFields(in);
        this.forestId = new BigInteger(forestIdText.getBytes());
        this.hostName = new String[1];
        this.hostName[0] = Text.readString((DataInput)in);
        this.isLastSplit = in.readBoolean();
        int replicaSize = in.readInt();
        this.replicas = new ArrayList<ForestHost>();
        for (int i = 0; i < replicaSize; ++i) {
            String curForest = Text.readString((DataInput)in);
            String curHost = Text.readString((DataInput)in);
            ForestHost fh = new ForestHost(curForest, curHost);
            this.replicas.add(fh);
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.start);
        out.writeLong(this.length);
        Text forestIdText = new Text(this.forestId.toByteArray());
        forestIdText.write(out);
        if (this.hostName != null && this.hostName.length > 0) {
            Text.writeString((DataOutput)out, (String)this.hostName[0]);
        }
        out.writeBoolean(this.isLastSplit);
        int replicaSize = this.replicas != null ? this.replicas.size() : 0;
        out.writeInt(replicaSize);
        for (int i = 0; i < replicaSize; ++i) {
            Text.writeString((DataOutput)out, (String)this.replicas.get(i).getForest());
            Text.writeString((DataOutput)out, (String)this.replicas.get(i).getHostName());
        }
    }

    public String toString() {
        return "start: " + this.start + ", length: " + this.length + ", forestId: " + this.forestId + ", hostName: " + (this.hostName != null && this.hostName.length > 0 ? this.hostName[0] : "null");
    }
}

