/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce.examples;

import com.marklogic.mapreduce.ContentType;
import com.marklogic.mapreduce.DatabaseDocument;
import com.marklogic.mapreduce.DocumentInputFormat;
import com.marklogic.mapreduce.DocumentURI;
import com.marklogic.mapreduce.SslConfigOptions;
import java.io.IOException;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.GenericOptionsParser;

public class ContentReader {
    public static void main(String[] args) throws Exception {
        Configuration conf = new Configuration();
        if (args.length < 2) {
            System.err.println("Usage: ContentReader configFile outputDir");
            System.exit(2);
        }
        String[] otherArgs = new GenericOptionsParser(conf, args).getRemainingArgs();
        Job job = Job.getInstance((Configuration)conf, (String)"content reader");
        job.setJarByClass(ContentReader.class);
        job.setInputFormatClass(DocumentInputFormat.class);
        job.setMapperClass(DocMapper.class);
        job.setMapOutputKeyClass(DocumentURI.class);
        job.setMapOutputValueClass(DatabaseDocument.class);
        job.setOutputFormatClass(CustomOutputFormat.class);
        CustomOutputFormat.setOutputPath((Job)job, (Path)new Path(otherArgs[1]));
        conf = job.getConfiguration();
        conf.addResource(otherArgs[0]);
        conf.setClass("mapreduce.marklogic.input.ssloptionsclass", SslOptions.class, SslConfigOptions.class);
        System.exit(job.waitForCompletion(true) ? 0 : 1);
    }

    static class CustomWriter
    extends RecordWriter<DocumentURI, DatabaseDocument> {
        Path dir;
        Configuration conf;
        FileSystem fs;

        public CustomWriter(Path path, Configuration conf) {
            this.dir = path;
            this.conf = conf;
            try {
                this.fs = path.getFileSystem(conf);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }

        public void close(TaskAttemptContext arg0) throws IOException, InterruptedException {
        }

        public void write(DocumentURI key, DatabaseDocument content) throws IOException, InterruptedException {
            Path path = null;
            try {
                URI uri = new URI(key.getUri());
                String pathname = uri.getPath();
                int nameStart = pathname.lastIndexOf(47);
                String filename = nameStart > 0 ? pathname.substring(pathname.lastIndexOf(47)) : pathname;
                String pathStr = this.dir.getName() + "/" + filename;
                path = new Path(pathStr);
                FSDataOutputStream out = this.fs.create(path, false);
                System.out.println("writing to: " + path);
                if (content.getContentType() == ContentType.BINARY) {
                    byte[] byteArray = content.getContentAsByteArray();
                    out.write(byteArray, 0, byteArray.length);
                    out.flush();
                    out.close();
                } else {
                    Text text = content.getContentAsText();
                    out.writeChars(text.toString());
                }
            }
            catch (Exception ex) {
                System.err.println("Failed to create or write to file: " + path);
                ex.printStackTrace();
            }
        }
    }

    static class CustomOutputFormat
    extends FileOutputFormat<DocumentURI, DatabaseDocument> {
        CustomOutputFormat() {
        }

        public RecordWriter<DocumentURI, DatabaseDocument> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
            return new CustomWriter(CustomOutputFormat.getOutputPath((JobContext)context), context.getConfiguration());
        }
    }

    static class SslOptions
    implements SslConfigOptions {
        SslOptions() {
        }

        @Override
        public String[] getEnabledCipherSuites() {
            return new String[]{"TLS_DHE_RSA_WITH_AES_256_CBC_SHA", "TLS_DHE_DSS_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA"};
        }

        @Override
        public String[] getEnabledProtocols() {
            return new String[]{"TLSv1"};
        }

        @Override
        public SSLContext getSslContext() {
            SSLContext sslContext = null;
            try {
                sslContext = SSLContext.getInstance("TLSv1");
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            TrustManager[] trustManagers = null;
            trustManagers = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            }};
            KeyManager[] keyManagers = null;
            try {
                sslContext.init(keyManagers, trustManagers, null);
            }
            catch (KeyManagementException e) {
                e.printStackTrace();
            }
            return sslContext;
        }
    }

    public static class DocMapper
    extends Mapper<DocumentURI, DatabaseDocument, DocumentURI, DatabaseDocument> {
        public static final Log LOG = LogFactory.getLog(DocMapper.class);

        public void map(DocumentURI key, DatabaseDocument value, Mapper.Context context) throws IOException, InterruptedException {
            if (key != null && value != null) {
                context.write((Object)key, (Object)value);
            } else {
                LOG.error((Object)("key: " + key + ", value: " + value));
            }
        }
    }
}

