/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce.examples;

import com.marklogic.mapreduce.MarkLogicNode;
import com.marklogic.mapreduce.NodeInputFormat;
import com.marklogic.mapreduce.NodeOutputFormat;
import com.marklogic.mapreduce.NodePath;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.util.GenericOptionsParser;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class LinkCountInDoc {
    public static void main(String[] args) throws Exception {
        Configuration conf = new Configuration();
        if (args.length < 1) {
            System.err.println("Usage: LinkCountInDoc configFile");
            System.exit(2);
        }
        String[] otherArgs = new GenericOptionsParser(conf, args).getRemainingArgs();
        Job job = Job.getInstance((Configuration)conf, (String)"link count in doc");
        job.setJarByClass(LinkCountInDoc.class);
        job.setInputFormatClass(NodeInputFormat.class);
        job.setMapperClass(RefMapper.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(IntWritable.class);
        job.setReducerClass(IntSumReducer.class);
        job.setOutputFormatClass(NodeOutputFormat.class);
        job.setOutputKeyClass(NodePath.class);
        job.setOutputValueClass(MarkLogicNode.class);
        conf = job.getConfiguration();
        conf.addResource(otherArgs[0]);
        System.exit(job.waitForCompletion(true) ? 0 : 1);
    }

    public static class IntSumReducer
    extends Reducer<Text, IntWritable, NodePath, MarkLogicNode> {
        private static final String TEMPLATE = "<ref-count>0</ref-count>";
        private static final String ROOT_ELEMENT_NAME = "//wp:page";
        private static final String BASE_URI_PARAM_NAME = "mapreduce.linkcount.baseuri";
        private NodePath nodePath = new NodePath();
        private Element element;
        private MarkLogicNode result;
        private String baseUri;

        protected void setup(Reducer.Context context) throws IOException, InterruptedException {
            try {
                DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                ByteArrayInputStream sbis = new ByteArrayInputStream(TEMPLATE.getBytes());
                this.element = docBuilder.parse(sbis).getDocumentElement();
                this.result = new MarkLogicNode(this.element);
                this.baseUri = context.getConfiguration().get(BASE_URI_PARAM_NAME);
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void reduce(Text key, Iterable<IntWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            int sum = 0;
            if (this.isInvalidName(key)) {
                return;
            }
            for (IntWritable val : values) {
                sum += val.get();
            }
            StringBuilder buf = new StringBuilder();
            buf.append(this.baseUri).append(key);
            this.nodePath.setDocumentUri(buf.toString());
            this.nodePath.setRelativePath(ROOT_ELEMENT_NAME);
            this.element.setTextContent(Integer.toString(sum));
            context.write((Object)this.nodePath, (Object)this.result);
        }

        private boolean isInvalidName(Text key) {
            String keyString = key.toString();
            return keyString == null || keyString.isEmpty() || keyString.matches("( )*");
        }
    }

    public static class RefMapper
    extends Mapper<NodePath, MarkLogicNode, Text, IntWritable> {
        private static final IntWritable one = new IntWritable(1);
        private Text refURI = new Text();

        public void map(NodePath key, MarkLogicNode value, Mapper.Context context) throws IOException, InterruptedException {
            if (value != null && value.get() != null) {
                Attr title = (Attr)value.get();
                String href = title.getValue();
                this.refURI.set(href.trim());
                context.write((Object)this.refURI, (Object)one);
            }
        }
    }
}

