/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce.functions;

import com.marklogic.mapreduce.functions.LexiconFunction;
import java.util.Collection;
import java.util.Iterator;

public abstract class CooccurrencesFunction
extends LexiconFunction {
    abstract void appendFunctionName(StringBuilder var1);

    abstract void appendNamesParams(StringBuilder var1);

    @Override
    public String getInputQuery(Collection<String> nsCol, long start, long count) {
        StringBuilder buf = new StringBuilder();
        buf.append("xquery version \"1.0-ml\";\n");
        buf.append("let $M := xdmp:with-namespaces((");
        if (nsCol != null) {
            Iterator<String> nsIt = nsCol.iterator();
            while (nsIt.hasNext()) {
                String ns = nsIt.next();
                buf.append('\"').append(ns).append('\"');
                if (!nsIt.hasNext()) continue;
                buf.append(',');
            }
        }
        buf.append("),");
        this.appendFunctionName(buf);
        buf.append("(");
        this.appendNamesParams(buf);
        buf.append("(\"skip=").append(start);
        buf.append("\",\"truncate=").append(count).append("\"");
        buf.append(",\"map\"");
        String[] userOptions = this.getUserDefinedOptions();
        if (userOptions != null) {
            for (String userOption : userOptions) {
                buf.append(",\"").append(userOption).append("\"");
            }
        }
        buf.append("),\n");
        buf.append(this.getLexiconQuery()).append("))\n");
        buf.append("for $k in map:keys($M)\n");
        buf.append("let $v := map:get($M, $k)\n");
        buf.append("for $each in $v\n");
        buf.append("return ($k, $each)\n");
        return buf.toString();
    }
}

