/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce.test;

import com.marklogic.mapreduce.ContentType;
import com.marklogic.mapreduce.DocumentURI;
import com.marklogic.mapreduce.ForestDocument;
import com.marklogic.mapreduce.ForestInputFormat;
import com.marklogic.mapreduce.JSONDocument;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class MapTreeReduceTreeJSON
extends Configured
implements Tool {
    public int run(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Usage: MapTreeReduceTree inputpath outputpath");
            System.exit(2);
        }
        Job job = Job.getInstance((Configuration)super.getConf());
        job.setJarByClass(MapTreeReduceTreeJSON.class);
        job.setInputFormatClass(ForestInputFormat.class);
        job.setMapperClass(MyMapper.class);
        job.setMapOutputKeyClass(DocumentURI.class);
        job.setMapOutputValueClass(JSONDocument.class);
        job.setReducerClass(MyReducer.class);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(args[0])});
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(args[1]));
        job.waitForCompletion(true);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = new Configuration();
        int res = ToolRunner.run((Configuration)conf, (Tool)new MapTreeReduceTreeJSON(), (String[])args);
        System.exit(res);
    }

    public static class MyReducer
    extends Reducer<DocumentURI, JSONDocument, Text, Text> {
        Text keyText = new Text();
        Text valText = new Text();

        public void reduce(DocumentURI key, Iterable<ForestDocument> docs, Reducer.Context context) throws IOException, InterruptedException {
            for (ForestDocument val : docs) {
                this.keyText.set(key.getUri());
                this.valText.set(val.getContentAsByteArray());
                context.write((Object)this.keyText, (Object)this.valText);
            }
        }
    }

    public static class MyMapper
    extends Mapper<DocumentURI, ForestDocument, DocumentURI, JSONDocument> {
        public static final Log LOG = LogFactory.getLog(MyMapper.class);

        public void map(DocumentURI key, JSONDocument value, Mapper.Context context) throws IOException, InterruptedException {
            if (value != null && value.getContentType() == ContentType.JSON) {
                System.out.println(key);
                System.out.println(value);
                context.write((Object)key, (Object)value);
            }
        }
    }
}

