/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce.test;

import com.marklogic.mapreduce.ValueInputFormat;
import com.marklogic.mapreduce.functions.PathReference;
import com.marklogic.mapreduce.functions.Reference;
import com.marklogic.mapreduce.functions.Values;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.GenericOptionsParser;

public class ValuesTest {
    public static void main(String[] args) throws Exception {
        Configuration conf = new Configuration();
        String[] otherArgs = new GenericOptionsParser(conf, args).getRemainingArgs();
        if (otherArgs.length < 2) {
            System.err.println("Usage: ValuesTest configFile outputDir");
            System.exit(2);
        }
        Job job = Job.getInstance((Configuration)conf);
        job.setJarByClass(ValuesTest.class);
        job.setInputFormatClass(ValueInputFormat.class);
        job.setMapperClass(ValueMapper.class);
        job.setMapOutputKeyClass(LongWritable.class);
        job.setMapOutputValueClass(Text.class);
        job.setOutputFormatClass(TextOutputFormat.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(otherArgs[1]));
        conf = job.getConfiguration();
        conf.addResource(otherArgs[0]);
        conf.setClass("mapreduce.marklogic.input.valueclass", Text.class, Writable.class);
        conf.setClass("mapreduce.marklogic.input.lexiconfunctionclass", ValuesFunction.class, Values.class);
        System.exit(job.waitForCompletion(true) ? 0 : 1);
    }

    static class MyPathReference
    extends PathReference {
        MyPathReference() {
        }

        @Override
        public String getPathExpression() {
            return "/my:a[@his:b='B1']/my:c";
        }
    }

    static class ValuesFunction
    extends Values {
        ValuesFunction() {
        }

        @Override
        public Reference[] getReferences() {
            MyPathReference pathRef = new MyPathReference();
            return new Reference[]{pathRef};
        }
    }

    public static class ValueMapper
    extends Mapper<LongWritable, Text, LongWritable, Text> {
        public void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            context.write((Object)key, (Object)value);
        }
    }
}

