/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce.utilities;

import com.marklogic.mapreduce.DocumentURI;
import com.marklogic.mapreduce.LinkedMapWritable;
import com.marklogic.mapreduce.utilities.AssignmentPolicy;
import com.marklogic.mapreduce.utilities.BucketAssignmentPolicy;
import com.marklogic.mapreduce.utilities.ForestHost;
import com.marklogic.mapreduce.utilities.ForestInfo;
import com.marklogic.mapreduce.utilities.LegacyAssignmentPolicy;
import com.marklogic.mapreduce.utilities.QueryAssignmentPolicy;
import com.marklogic.mapreduce.utilities.RangeAssignmentPolicy;
import com.marklogic.mapreduce.utilities.SegmentAssignmentPolicy;
import com.marklogic.mapreduce.utilities.StatisticalAssignmentPolicy;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class AssignmentManager {
    static final String ID_PREFIX = "#";
    protected AssignmentPolicy policy;
    protected long effectiveVersion;
    private static final AssignmentManager instance = new AssignmentManager();
    private boolean initialized = false;
    private String[] masterIds;
    private LinkedHashMap<String, List<ForestHost>> replicaMap;

    private AssignmentManager() {
    }

    public static AssignmentManager getInstance() {
        return instance;
    }

    public synchronized AssignmentPolicy getPolicy() {
        return this.policy;
    }

    public synchronized void initialize(AssignmentPolicy.Kind kind, LinkedMapWritable map, int batchSize) {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        LinkedHashSet<String> forests = new LinkedHashSet<String>();
        LinkedHashSet<String> updatableForests = new LinkedHashSet<String>();
        this.replicaMap = new LinkedHashMap();
        for (Writable f : map.keySet()) {
            String fId = ((Text)f).toString();
            ForestInfo fs = (ForestInfo)map.get(f);
            this.replicaMap.put(fId, fs.getReplicas());
            if (fs.getUpdatable()) {
                updatableForests.add(fId);
            }
            forests.add(fId);
        }
        this.masterIds = forests.toArray(new String[forests.size()]);
        switch (kind) {
            case BUCKET: {
                this.initBucketPolicy(forests.toArray(new String[forests.size()]), updatableForests);
                break;
            }
            case LEGACY: {
                this.initLegacyPolicy(updatableForests);
                break;
            }
            case SEGMENT: {
                this.initSegmentPolicy(updatableForests);
                break;
            }
            case RANGE: {
                String[] uForests = updatableForests.toArray(new String[updatableForests.size()]);
                long[] countAry = new long[updatableForests.size()];
                for (int i = 0; i < countAry.length; ++i) {
                    countAry[i] = ((ForestInfo)map.get(new Text(uForests[i]))).getFragmentCount();
                }
                this.initRangePolicy(countAry, batchSize);
                break;
            }
            case STATISTICAL: {
                String[] uForests = updatableForests.toArray(new String[updatableForests.size()]);
                long[] countAry = new long[updatableForests.size()];
                for (int i = 0; i < countAry.length; ++i) {
                    countAry[i] = ((ForestInfo)map.get(new Text(uForests[i]))).getFragmentCount();
                }
                this.initStatisticalPolicy(countAry, batchSize);
                break;
            }
            case QUERY: {
                String[] uForests = updatableForests.toArray(new String[updatableForests.size()]);
                long[] countAry = new long[updatableForests.size()];
                for (int i = 0; i < countAry.length; ++i) {
                    countAry[i] = ((ForestInfo)map.get(new Text(uForests[i]))).getFragmentCount();
                }
                this.initQueryPolicy(countAry, batchSize);
            }
        }
    }

    public void initBucketPolicy(String[] forests, LinkedHashSet<String> uForests) {
        this.policy = new BucketAssignmentPolicy(forests, uForests);
    }

    public void initRangePolicy(long[] docCount, int batchSize) {
        this.policy = new RangeAssignmentPolicy(docCount, batchSize);
    }

    public void initStatisticalPolicy(long[] docCount, int batchSize) {
        this.policy = new StatisticalAssignmentPolicy(docCount, batchSize);
    }

    public void initQueryPolicy(long[] docCount, int batchSize) {
        this.policy = new QueryAssignmentPolicy(docCount, batchSize);
    }

    public void initLegacyPolicy(LinkedHashSet<String> uForests) {
        this.policy = new LegacyAssignmentPolicy(uForests);
    }

    public void initSegmentPolicy(LinkedHashSet<String> uForests) {
        this.policy = new SegmentAssignmentPolicy(uForests);
    }

    public int getPlacementForestIndex(DocumentURI uri) {
        return this.policy.getPlacementForestIndex(uri);
    }

    public String[] getMasterIds() {
        return this.masterIds;
    }

    public List<ForestHost> getReplicas(String id) {
        return this.replicaMap.get(id);
    }

    public void setInitialized(boolean val) {
        this.initialized = val;
    }

    public long getEffectiveVersion() {
        return this.effectiveVersion;
    }

    public void setEffectiveVersion(long effectiveVersion) {
        this.effectiveVersion = effectiveVersion;
    }
}

