/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce.utilities;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RestrictedHostsUtil {
    public static final Log LOG = LogFactory.getLog(RestrictedHostsUtil.class);
    protected Map<String, HostAssignment> mp;
    protected PriorityQueue<String> q;
    protected List<String> restrictHosts;

    public RestrictedHostsUtil(String[] restrictHosts) {
        this.restrictHosts = Arrays.asList(restrictHosts);
        this.mp = new HashMap<String, HostAssignment>();
        this.q = new PriorityQueue<String>(restrictHosts.length, new HostAssginmentComparator());
        for (int i = 0; i < restrictHosts.length; ++i) {
            this.mp.put(restrictHosts[i], new HostAssignment(i));
            this.q.add(restrictHosts[i]);
        }
    }

    public void addForestHost(String hostname) {
        if (this.restrictHosts.contains(hostname)) {
            ++this.mp.get((Object)hostname).assignmentCount;
            this.q.remove(hostname);
            this.q.add(hostname);
        }
    }

    public String getNextHost(String hostName) {
        if (this.restrictHosts.contains(hostName)) {
            return hostName;
        }
        String targetHost = this.q.poll();
        ++this.mp.get((Object)targetHost).assignmentCount;
        this.q.add(targetHost);
        return targetHost;
    }

    protected class HostAssginmentComparator
    implements Comparator<String> {
        protected HostAssginmentComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            HostAssignment h1 = RestrictedHostsUtil.this.mp.get(o1);
            HostAssignment h2 = RestrictedHostsUtil.this.mp.get(o2);
            if (h1.assignmentCount != h2.assignmentCount) {
                return h1.assignmentCount - h2.assignmentCount;
            }
            return h1.index - h2.index;
        }
    }

    protected class HostAssignment {
        public int index = 0;
        public int assignmentCount = 0;

        HostAssignment(int index) {
            this.index = index;
        }
    }
}

