/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.impl.handlers;

import com.marklogic.http.HttpChannel;
import com.marklogic.xcc.ModuleInvoke;
import com.marklogic.xcc.ModuleSpawn;
import com.marklogic.xcc.Request;
import com.marklogic.xcc.exceptions.PDCloudRequestException;
import com.marklogic.xcc.exceptions.RequestException;
import com.marklogic.xcc.exceptions.ServerResponseException;
import com.marklogic.xcc.impl.handlers.ResponseHandler;
import java.io.IOException;
import java.util.logging.Logger;

public class NotFoundCodeHandler
implements ResponseHandler {
    @Override
    public Object handleResponse(HttpChannel http, int responseCode, Request request, Object attachment, Logger logger) throws RequestException {
        String responseMsg = this.getResponseMessage(http);
        String queryType = "Query evaluation";
        if (request instanceof ModuleInvoke) {
            queryType = "Module invocation";
        }
        if (request instanceof ModuleSpawn) {
            queryType = "Module spawn";
        }
        if (request.getSession().getUserCredentials().getPDCloudAuthConfig() != null) {
            throw new PDCloudRequestException("(" + responseCode + ", " + responseMsg + "). Invalid request URL.", request, false);
        }
        throw new ServerResponseException(queryType + " request rejected (" + responseCode + ", " + responseMsg + "). ", request, responseCode, responseMsg);
    }

    private String getResponseMessage(HttpChannel http) {
        try {
            return http.getResponseMessage();
        }
        catch (IOException e) {
            return "No Message";
        }
    }
}

