/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.types.impl;

import com.marklogic.xcc.types.CtsCircle;
import com.marklogic.xcc.types.CtsPoint;
import com.marklogic.xcc.types.ValueType;
import com.marklogic.xcc.types.impl.AbstractStringItem;
import com.marklogic.xcc.types.impl.CtsPointImpl;

public class CtsCircleImpl
extends AbstractStringItem
implements CtsCircle {
    private String radius;
    private CtsPoint center;

    public CtsCircleImpl(String value) {
        super(ValueType.CTS_CIRCLE, value);
    }

    public CtsCircleImpl(String radius, CtsPoint center) {
        super(ValueType.CTS_CIRCLE, null);
        this.radius = radius;
        this.center = center;
    }

    private void parse() {
        try {
            int i = this.value.indexOf(32, 1);
            this.radius = this.value.substring(1, i);
            this.center = new CtsPointImpl(this.value.substring(i + 1));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to parse value as cts:circle: " + this.value);
        }
    }

    @Override
    public String asString() {
        if (this.value == null) {
            this.value = String.format("@%s %s,%s", this.radius, this.center.getLatitude(), this.center.getLongitude());
        }
        return this.value;
    }

    @Override
    public String getRadius() {
        if (this.radius == null) {
            this.parse();
        }
        return this.radius;
    }

    @Override
    public CtsPoint getCenter() {
        if (this.center == null) {
            this.parse();
        }
        return this.center;
    }
}

