@echo off

REM Values to change include VERSION and SUBLOC, both below.

REM The subdirectory to install into
SET SUBLOC="1001"

if NOT "%1"=="" SET VERSION="%1"
if NOT "%1"=="" GOTO GOT_VERSION

REM The full version number of the build in XXXX.XX.XX format
SET VERSION="10.01.0000"

echo.
echo Version not specified - defaulting to %VERSION%
echo.

:GOT_VERSION
where /q candle.exe || PATH %PATH%;%WIX%\bin


echo.
echo Building mlsqlODBC_32 merge module...

candle -nologo -dVERSION=%VERSION% -dSUBLOC=%SUBLOC% -dPROGRAMFILES="%ProgramFiles(x86)%" -dSYSTEM32DIR="%SystemRoot%/system32" mlsqlodbcm_32.wxs
IF ERRORLEVEL 1 GOTO ERR_HANDLER

echo "candle done"
light -sice:ICE30 -nologo -out mlsqlodbc_32.msm mlsqlodbcm_32.wixobj
IF ERRORLEVEL 1 GOTO ERR_HANDLER

echo.
echo Building mlsqlODBC_32 installer database...

candle -nologo -dVERSION=%VERSION% -dSUBLOC=%SUBLOC% -dPROGRAMFILES="%ProgramFiles%" -dPROGRAMCOM="%ProgramFiles%/Common Files/Merge Modules" mlsqlodbc_32.wxs
IF ERRORLEVEL 1 GOTO ERR_HANDLER

light -sice:ICE30 -nologo -ext WixUIExtension -cultures:en-us mlsqlodbc_32.wixobj
IF ERRORLEVEL 1 GOTO ERR_HANDLER

echo.
echo Done!
GOTO EXIT

:ERR_HANDLER
echo.
echo Aborting build!
EXIT /B 1

:EXIT
