@echo off

:: Values to change include VERSION and SUBLOC, both below.

setlocal
SET X86PROGRAMFILES=%ProgramFiles%
SET X86COMMONFILES=%CommonProgramFiles%

if "%PROCESSOR_ARCHITECTURE%" == "x86" GOTO SET_LINKFILES
SET X86PROGRAMFILES=%ProgramFiles(x86)%
SET X86COMMONFILES=%CommonProgramFiles(x86)%

:SET_LINKFILES
:: echo X86PROGRAMFILES=%X86PROGRAMFILES%
:: echo X86COMMONFILES=%X86COMMONFILES%
::
:: When you reference PG server's libpq related dlls, set the
:: version to the variable PGVERSION (default 9.2) and call 
:: this batch file.
::
if "%PGVERSION%" == "" SET PGVERSION=9.2
::
:: When you placed libpq related dlls in the folder other than
:: the default one, set the folder name to the variable LIBPQBINDIR
:: and call this batch file.
::
SET LINKFILES=amd64
:: if "%LIBPQBINDIR%" == "" (
:: 	SET LINKFILES=%X86PROGRAMFILES%\PostgreSQL\%PGVERSION%\bin
::  ) else (
:: 	SET LINKFILES=%LIBPQBINDIR%
::  )

if NOT "%1"=="" (
       SET VERSION="%1"
       GOTO GOT_VERSION
)

:: The full version number of the build in XXXX.XX.XX format
SET VERSION="10.01.0000"
echo.
echo Version not specified - defaulting to %VERSION%
echo.

:GOT_VERSION

:: The subdirectory to install into
SET SUBLOC="1001"

echo.
echo Building mlsqlODBC/%SUBLOC% merge module...

candle -nologo -dVERSION=%VERSION% -dSUBLOC=%SUBLOC% -dLINKFILES="%LINKFILES%" mlsqlodbcm.wxs
IF ERRORLEVEL 1 GOTO ERR_HANDLER

light -sice:ICE30 -nologo -out mlsqlodbc.msm mlsqlodbcm.wixobj
IF ERRORLEVEL 1 GOTO ERR_HANDLER

echo.
echo Building mlsqlODBC installer database...

REM candle -nologo -dVERSION=%VERSION% -dSUBLOC=%SUBLOC% -dPROGRAMFILES="%X86PROGRAMFILES%" -dPROGRAMCOM="%X86COMMONFILES%\Merge Modules" mlsqlodbc.wxs
candle -nologo -dVERSION=%VERSION% -dSUBLOC=%SUBLOC% -dPROGRAMFILES="%ProgramFiles%" -dPROGRAMCOM="%ProgramFiles(x86)%/Common Files/Merge Modules" mlsqlodbc.wxs
IF ERRORLEVEL 1 GOTO ERR_HANDLER

light -sice:ICE30 -nologo -ext WixUIExtension -cultures:en-us mlsqlodbc.wixobj
IF ERRORLEVEL 1 GOTO ERR_HANDLER

echo.
echo Done!
GOTO EXIT

:ERR_HANDLER
echo.
echo Aborting build!
EXIT /B 1

:EXIT
endlocal
